/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl.shader;

import frc.emul.vectrex.ui.opengl.shader.IShaderSource;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;

public class FileShaderSource
implements IShaderSource {
    private final File source;

    public FileShaderSource(String string) {
        this(new File(string));
    }

    public FileShaderSource(File file) {
        this.source = file;
    }

    public String getID() {
        return this.source.getPath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContent() {
        String string;
        InputStreamReader inputStreamReader = null;
        try {
            char[] cArray = new char[(int)this.source.length()];
            inputStreamReader = new FileReader(this.source);
            int n = inputStreamReader.read(cArray);
            string = new String(cArray, 0, n);
            if (inputStreamReader == null) return string;
        }
        catch (Exception exception) {
            try {
                throw new RuntimeException("Error while loading shader source file " + this.source.getPath(), exception);
            }
            catch (Throwable throwable) {
                if (inputStreamReader == null) throw throwable;
                try {
                    inputStreamReader.close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
        }
        try {
            inputStreamReader.close();
            return string;
        }
        catch (Exception exception) {}
        return string;
    }
}

